	NAME	mszz10
; File MSZZ10.ASM
	include mssdef.h
;       Copyright (C) 1982,1991, Trustees of Columbia University in the
;       City of New York.  Permission is granted to any individual or
;       institution to use, copy, or redistribute this software as long as
;       it is not sold for profit and this copyright notice is retained.
; Terminal emulator module for Zenith-100 based on mszibm.asm.
; Most of the contents of this file including all of the VT100/VT52
; emulation is left inactive (commented out).  I hope to be able to
; come back with a more complete implementation later on.
; Edit history
; 2 March 1991 version 3.10
; Last change: 3 May 1990.
; Bo Gedda
; 
; Terminal emulator module for IBM PC's and compatibles. Emulates Heath-19,
; VT52, VT102, and VT320. Original version for VT100 done by James Harvey,
; Indiana Purdue Univ, for MS Kermit 2.27. Taken from there by Joe Doupnik,
; Utah State Univ for MS Kermit 2.29 et seq.

; * Disclaimer *
;
; DEC and VT are trademarks of Digital Equipment Corporation.
; References:
;  "PT200 Programmers Reference Guide", 1984, Prime Computer # DOC 8621-001P
;  "Video Terminal Model H19, Operation", 1979, Heath Company # 595-2284-05
;  "VT100 User's Guide", 2nd ed., Jan 1979, DEC # EK-VT100-UG
;  "Rainbow 100+/100B Terminal Emulation Manual", June 1984, DEC # QV069-GZ
;  "Installing and Using The VT320 Video Terminal", June 1987,
;	DEC # EK-VT320-UU-001
;  "VT320 Programmer Reference Manual", July 1987, DEC # EK-VT320-RM-001
; ---------------------------------------------------------------------------

	public	nrc2cp, cpdecsg

data	segment
	extrn	flags:byte, dosnum:word

	; DEC National Replacement Char sets, one table for each Code Page
						; CP437
; 12 replacment bytes (keyed by ASCII bytes), NRC number, country, size, ident
nrc437	db	23h,40h,5bh,5ch,5dh,5eh		; 0, ASCII, "B", dispatch ref
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'B',0			; 94 byte set, letter pair
	db	9ch,40h,5bh,5ch,5dh,5eh		; 1, British, "A"
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'A',0
	db	9ch,3fh,98h,0abh,7ch,5eh	; 2, Dutch, "4"
	db	5fh,60h,22h,9fh,0ach,27h
	db	94,'4',0
	db	23h,40h,8eh,99h,8fh,9ah		; 3, Finnish, "5"
	db	5fh,82h,84h,94h,86h,81h
	db	94,'5',0
	db	9ch,85h,0f8h,87h,15h,5eh	; 4, French, "R"
	db	5fh,60h,82h,97h,8ah,22h
	db	94,'R',0
	db	23h,85h,83h,87h,88h,8ch		; 5, French Canadian, "9"
	db	5fh,93h,82h,97h,8ah,96h
	db	94,'9',0
	db	23h,15h,8eh,99h,9ah,5eh		; 6, German, "K"
	db	5fh,60h,84h,94h,81h,0e1h
	db	94,'K',0
	db	9ch,15h,0f8h,87h,82h,5eh	; 7, Italian, "Y"
	db	5fh,97h,85h,95h,8ah,8dh
	db	94,'Y',0
	db	23h,40h,92h,0edh,8fh,5eh	; 8, Norwegian/Danish, "'"
	db	5fh,60h,91h,0edh,86h,7eh
	db	94,60h,0
	db	23h,40h,8eh,80h,99h,5eh		; 9, Portugese, "%6"
	db	5fh,60h,0a6h,87h,0a7h,7eh
	db	94,'%','6'
	db	9ch,15h,8ch,0a5h,0a8h,5eh	; 10, Spanish, "Z"
	db	5fh,60h,60h,0f8h,0a4h,87h
	db	94,'Z',0
	db	23h,90h,8eh,99h,8fh,9ah		; 11, Swedish, "7"
	db	5fh,82h,84h,94h,86h,81h
	db	94,'7',0
	db	97h,85h,82h,87h,88h,8ch		; 12, Swiss, "="
	db	8ah,93h,84h,94h,81h,96h
	db	94,'=',0

						; CP850
; 12 replacment bytes (keyed by ASCII bytes), NRC number, country, size, ident
nrc850	db	23h,40h,5bh,5ch,5dh,5eh		; 0, ASCII, "B", dispatch ref
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'B',0			; 94 byte set, letter pair
	db	9ch,40h,5bh,5ch,5dh,5eh		; 1, British, "A"
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'A',0
	db	9ch,0f3h,98h,0abh,7ch,5eh	; 2, Dutch, "4"
	db	5fh,60h,22h,9fh,0ach,27h
	db	94,'4',0
	db	23h,40h,8eh,99h,8fh,9ah		; 3, Finnish, "5"
	db	5fh,82h,84h,94h,86h,81h
	db	94,'5',0
	db	9ch,85h,0f8h,87h,15h,5eh	; 4, French, "R"
	db	5fh,60h,82h,97h,8ah,22h
	db	94,'R',0
	db	23h,85h,83h,87h,88h,8ch		; 5, French Canadian, "9"
	db	5fh,93h,82h,97h,8ah,96h
	db	94,'9',0
	db	23h,15h,8eh,99h,9ah,5eh		; 6, German, "K"
	db	5fh,60h,84h,94h,81h,0e1h
	db	94,'K',0
	db	9ch,15h,0f8h,87h,82h,5eh	; 7, Italian, "Y"
	db	5fh,97h,85h,95h,8ah,8dh
	db	94,'Y',0
	db	23h,40h,92h,09dh,8fh,5eh	; 8, Norwegian/Danish, "'"
	db	5fh,60h,91h,09bh,86h,7eh
	db	94,60h,0
	db	23h,40h,0b5h,80h,0e5h,5eh	; 9, Portugese, "%6"
	db	5fh,60h,61h,87h,0e4h,7eh
	db	94,'%','6'
	db	9ch,15h,0adh,0a5h,0a8h,5eh	; 10, Spanish, "Z"
	db	5fh,60h,60h,0f8h,0a4h,87h
	db	94,'Z',0
	db	23h,90h,8eh,99h,8fh,9ah		; 11, Swedish, "7"
	db	5fh,82h,84h,94h,86h,81h
	db	94,'7',0
	db	97h,85h,82h,87h,88h,8ch		; 12, Swiss, "="
	db	8ah,93h,84h,94h,81h,96h
	db	94,'=',0
						; CP860
; 12 replacment bytes (keyed by ASCII bytes), NRC number, country, size, ident
nrc860	db	23h,40h,5bh,5ch,5dh,5eh		; 0, ASCII, "B", dispatch ref
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'B',0			; 94 byte set, letter pair
	db	9ch,40h,5bh,5ch,5dh,5eh		; 1, British, "A"
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'A',0
	db	9ch,3fh,79h,0abh,7ch,5eh	; 2, Dutch, "4"
	db	5fh,60h,22h,3fh,0ach,27h
	db	94,'4',0
	db	23h,40h,41h,4fh,41h,9ah		; 3, Finnish, "5"
	db	5fh,82h,61h,6fh,61h,81h
	db	94,'5',0
	db	9ch,85h,0f8h,87h,15h,5eh	; 4, French, "R"
	db	5fh,60h,82h,97h,8ah,22h
	db	94,'R',0
	db	23h,85h,83h,87h,88h,69h		; 5, French Canadian, "9"
	db	5fh,93h,82h,97h,8ah,75h
	db	94,'9',0
	db	23h,15h,41h,4fh,9ah,5eh		; 6, German, "K"
	db	5fh,60h,61h,6fh,81h,0e1h
	db	94,'K',0
	db	9ch,15h,0f8h,87h,82h,5eh	; 7, Italian, "Y"
	db	5fh,97h,85h,95h,8ah,8dh
	db	94,'Y',0
	db	23h,40h,3fh,0edh,41h,5eh	; 8, Norwegian/Danish, "'"
	db	5fh,60h,3fh,0edh,61h,7eh
	db	94,60h,0
	db	23h,40h,8eh,80h,99h,5eh		; 9, Portugese, "%6"
	db	5fh,60h,84h,87h,94h,7eh
	db	94,'%','6'
	db	9ch,15h,0adh,0a5h,0a8h,5eh	; 10, Spanish, "Z"
	db	5fh,60h,60h,0f8h,0a4h,87h
	db	94,'Z',0
	db	23h,90h,41h,4fh,41h,9ah		; 11, Swedish, "7"
	db	5fh,82h,61h,6fh,61h,75h
	db	94,'7',0
	db	97h,85h,82h,87h,88h,69h		; 12, Swiss, "="
	db	8ah,93h,61h,6fh,81h,75h
	db	94,'=',0
						; CP863
; 12 replacment bytes (keyed by ASCII bytes), NRC number, country, size, ident
nrc863	db	23h,40h,5bh,5ch,5dh,5eh		; 0, ASCII, "B", dispatch ref
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'B',0			; 94 byte set, letter pair
	db	9ch,40h,5bh,5ch,5dh,5eh		; 1, British, "A"
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'A',0
	db	9ch,0adh,79h,0abh,7ch,5eh	; 2, Dutch, "4"
	db	5fh,60h,0a4h,9fh,0ach,0a1h
	db	94,'4',0
	db	23h,40h,41h,4fh,41h,55h		; 3, Finnish, "5"
	db	5fh,82h,61h,6fh,61h,81h
	db	94,'5',0
	db	9ch,85h,0f8h,87h,15h,5eh	; 4, French, "R"
	db	5fh,60h,82h,97h,8ah,0a4h
	db	94,'R',0
	db	23h,85h,83h,87h,88h,8ch		; 5, French Canadian, "9"
	db	5fh,93h,82h,97h,8ah,96h
	db	94,'9',0
	db	23h,15h,41h,4fh,9ah,5eh		; 6, German, "K"
	db	5fh,60h,61h,6fh,81h,0e1h
	db	94,'K',0
	db	9ch,15h,0f8h,87h,82h,5eh	; 7, Italian, "Y"
	db	5fh,97h,6fh,85h,8ah,69h
	db	94,'Y',0
	db	23h,40h,3fh,0edh,41h,5eh	; 8, Norwegian/Danish, "'"
	db	5fh,60h,0efh,0edh,61h,7eh
	db	94,60h,0
	db	23h,40h,41h,80h,4fh,5eh		; 9, Portugese, "%6"
	db	5fh,60h,61h,87h,6fh,7eh
	db	94,'%','6'
	db	9ch,15h,3fh,4eh,3fh,5eh		; 10, Spanish, "Z"
	db	5fh,60h,60h,0f8h,6eh,87h
	db	94,'Z',0
	db	23h,90h,41h,4fh,41h,9ah		; 11, Swedish, "7"
	db	5fh,82h,61h,6fh,61h,81h
	db	94,'7',0
	db	97h,85h,82h,87h,88h,8ch		; 12, Swiss, "="
	db	8ah,93h,61h,6fh,81h,96h
	db	94,'=',0
						; CP865
; 12 replacment bytes (keyed by ASCII bytes), NRC number, country, size, ident
nrc865	db	23h,40h,5bh,5ch,5dh,5eh		; 0, ASCII, "B", dispatch ref
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'B',0			; 94 byte set, letter pair
	db	9ch,40h,5bh,5ch,5dh,5eh		; 1, British, "A"
	db	5fh,60h,7bh,7ch,7dh,7eh
	db	94,'A',0
	db	9ch,3fh,98h,0abh,7ch,5eh	; 2, Dutch, "4"
	db	5fh,60h,22h,9fh,0ach,27h
	db	94,'4',0
	db	23h,40h,8eh,99h,8fh,9ah		; 3, Finnish, "5"
	db	5fh,82h,84h,94h,86h,81h
	db	94,'5',0
	db	9ch,85h,0f8h,87h,15h,5eh	; 4, French, "R"
	db	5fh,60h,82h,97h,8ah,22h
	db	94,'R',0
	db	23h,85h,83h,87h,88h,8ch		; 5, French Canadian, "9"
	db	5fh,93h,82h,97h,8ah,96h
	db	94,'9',0
	db	23h,15h,8eh,99h,9ah,5eh		; 6, German, "K"
	db	5fh,60h,84h,94h,81h,0e1h
	db	94,'K',0
	db	9ch,15h,0f8h,87h,82h,5eh	; 7, Italian, "Y"
	db	5fh,97h,85h,95h,8ah,8dh
	db	94,'Y',0
	db	23h,40h,92h,9dh,8fh,5eh		; 8, Norwegian/Danish, "'"
	db	5fh,60h,91h,9bh,86h,7eh
	db	94,60h,0
	db	23h,40h,41h,80h,4fh,5eh		; 9, Portugese, "%6"
	db	5fh,60h,61h,87h,6fh,7eh
	db	94,'%','6'
	db	9ch,15h,0adh,0a5h,0a8h,5eh	; 10, Spanish, "Z"
	db	5fh,60h,60h,0f8h,0a4h,87h
	db	94,'Z',0
	db	23h,90h,8eh,99h,8fh,9ah		; 11, Swedish, "7"
	db	5fh,82h,84h,94h,86h,81h
	db	94,'7',0
	db	97h,85h,82h,87h,88h,8ch		; 12, Swiss, "="
	db	8ah,93h,84h,94h,81h,96h
	db	94,'=',0

; Translation tables for byte codes 0a0h..0ffh to map DEC Multinational
; Character Set (DEC Supplemental Graphic) to Code Pages.
; Codes 00h-1fh are 7-bit controls (C0), codes 20h..7eh are ASCII, 7fh DEL is
; considered to be a control code, 80h..9fh are 8-bit controls (C1).
; Each table is 94 translatable bytes followed by the table size (94), the
; ISO announcer ident '%5'.
					; from DEC Multinational to Code Page
							; to CP437
MNcp437 db	80h,81h,82h,83h,   84h,85h,86h,87h	; column 8
	db	88h,89h,8ah,8bh,   8ch,8dh,8eh,8fh
	db	90h,91h,92h,93h,   94h,95h,96h,97h	; column 9
	db	98h,99h,9ah,9bh,   9ch,9dh,9eh,9fh
	db	0h,0adh,9bh,9ch,   20h,9dh,20h,15h	; column 10
	db	0fh,40h,0a6h,0aeh, 20h,20h,20h,20h
	db	0f8h,0f1h,0fdh,33h, 20h,0e6h,14h,0feh	; column 11
	db	2eh,60h,0a7h,0afh, 0ach,0abh,20h,0a8h
	db	85h,0a0h,83h,83h,  8eh,8fh,92h,80h	; column 12
	db	8ah,90h,88h,89h,   8dh,0a1h,8ch,8bh
	db	20h,0a5h,95h,0a2h, 93h,94h,94h,4fh	; column 13
	db	0edh,97h,0a3h,96h, 9ah,59h,20h,0e1h
	db	85h,0a0h,83h,84h,  84h,86h,91h,87h	; column 14
	db	8ah,82h,88h,89h,   8dh,0a1h,8ch,8bh
	db	20h,0a4h,95h,0a2h, 93h,94h,94h,6fh	; column 15
	db	0edh,97h,0a3h,96h, 81h,98h,20h,0h
	db	94,'%','5'			; 94 byte set, letter ident

							; to CP850
MNcp850 db	80h,81h,82h,83h,   84h,85h,86h,87h	; column 8
	db	88h,89h,8ah,8bh,   8ch,8dh,8eh,8fh
	db	90h,91h,92h,93h,   94h,95h,96h,97h	; column 9
	db	98h,99h,9ah,9bh,   9ch,9dh,9eh,9fh
	db	0h,0adh,0bdh,9ch,  20h,0beh,20h,15h	; column 10
	db	0cfh,0b8h,0a6h,0aeh, 20h,20h,20h,20h
	db	0f8h,0f1h,0fdh,0fch, 20h,0e6h,14h,0feh	; column 11
	db	2eh,0fbh,0a7h,0afh, 0ach,0abh,20h,0a8h
	db	0b7h,0b5h,0b6h,0b5h, 8eh,8fh,92h,80h	; column 12
	db	0d4h,90h,0d2h,0d3h, 0deh,0d6h,0d7h,0d8h
	db	20h,0a5h,0e3h,0e0h, 0e2h,0e5h,99h,4fh	; column 13
	db	9dh,0ebh,0e9h,0eah, 9ah,0edh,20h,0e1h
	db	85h,0a0h,83h,61h,   84h,86h,91h,87h	; column 14
	db	8ah,82h,88h,89h,    8dh,0a1h,8ch,8bh
	db	20h,0a4h,95h,0a2h,  93h,0e4h,94h,6fh	; column 15
	db	9bh,97h,0a3h,96h,   81h,0ech,20h,0h
	db	94,'%','5'			; 94 byte set, letter ident
							; to CP860
MNcp860 db	80h,81h,82h,83h,   84h,85h,86h,87h	; column 8
	db	88h,89h,8ah,8bh,   8ch,8dh,8eh,8fh
	db	90h,91h,92h,93h,   94h,95h,96h,97h	; column 9
	db	98h,99h,9ah,9bh,   9ch,9dh,9eh,9fh
	db	0h,0adh,9bh,9ch,   20h,59h,20h,15h	; column 10
	db	0fh,3fh,0a6h,0aeh, 20h,20h,20h,20h
	db	0f8h,0f1h,0fdh,33h, 20h,0e6h,14h,0feh	; column 11
	db	2eh,60h,0a7h,0afh, 0ach,0abh,20h,0a8h
	db	85h,0a0h,83h,83h,  8eh,8fh,92h,80h	; column 12
	db	8ah,90h,88h,89h,   8dh,0a1h,8ch,8bh
	db	20h,0a5h,95h,0a2h, 93h,94h,94h,4fh	; column 13
	db	0edh,97h,0a3h,96h, 9ah,59h,20h,0e1h
	db	85h,0a0h,83h,84h,  84h,86h,91h,87h	; column 14
	db	8ah,82h,88h,89h,   8dh,0a1h,8ch,8bh
	db	20h,0a4h,95h,0a2h, 93h,94h,94h,6fh	; column 15
	db	0edh,97h,0a3h,96h, 81h,98h,20h,0h
	db	94,'%','5'			; 94 byte set, letter ident
							; to CP863
MNcp863 db	80h,81h,82h,83h,   84h,85h,86h,87h	; column 8
	db	88h,89h,8ah,8bh,   8ch,8dh,8eh,8fh
	db	90h,91h,92h,93h,   94h,95h,96h,97h	; column 9
	db	98h,99h,9ah,9bh,   9ch,9dh,9eh,9fh
	db	0h,0adh,9bh,9ch,   20h,9dh,20h,15h	; column 10
	db	98h,40h,61h,0aeh,  20h,20h,20h,20h
	db	0f8h,0f1h,0fdh,33h, 20h,0e6h,86h,0feh	; column 11
	db	2eh,31h,6fh,0afh,  0ach,0abh,20h,3fh
	db	8eh,41h,84h,41h,   41h,41h,3fh,80h	; column 12
	db	91h,90h,92h,94h,   49h,49h,88h,95h
	db	20h,4eh,4fh,4fh,   99h,4fh,4fh,4fh	; column 13
	db	0edh,9dh,55h,0aeh, 55h,59h,20h,0e1h
	db	85h,61h,83h,61h,   61h,61h,3fh,87h	; column 14
	db	8ah,82h,88h,89h,   69h,69h,8ch,8bh
	db	20h,6eh,6fh,0a2h,  93h,6fh,6fh,6fh	; column 15
	db	0edh,97h,0a3h,96h, 75h,79h,20h,0h
	db	94,'%','5'			; 94 byte set, letter ident
							; to CP865
MNcp865 db	80h,81h,82h,83h,   84h,85h,86h,87h	; column 8
	db	88h,89h,8ah,8bh,   8ch,8dh,8eh,8fh
	db	90h,91h,92h,93h,   94h,95h,96h,97h	; column 9
	db	98h,99h,9ah,9bh,   9ch,9dh,9eh,9fh
	db	0h,0adh,3fh,9ch,   20h,3fh,20h,15h	; column 10
	db	0afh,3fh,0a6h,0aeh, 20h,20h,20h,20h
	db	0f8h,0f1h,0fdh,33h, 20h,0e6h,14h,0feh	; column 11
	db	2eh,31h,0a7h,03fh, 0ach,0abh,20h,0a8h
	db	41h,41h,41h,41h,   8eh,8fh,92h,80h	; column 12
	db	45h,90h,45h,45h,   49h,49h,49h,49h
	db	20h,0a5h,4fh,4fh,  4fh,4fh,99h,4fh	; column 13
	db	0edh,55h,55h,55h,  9ah,59h,20h,0e1h
	db	85h,0a0h,83h,61h,  84h,86h,91h,87h	; column 14
	db	8ah,82h,88h,89h,   8dh,0a1h,8ch,8bh
	db	20h,0a4h,95h,0a2h, 93h,6fh,94h,6fh	; column 15
	db	0edh,97h,0a3h,96h, 81h,79h,20h,0h
	db	94,'%','5'			; 94 byte set, letter ident

; 128 byte translation tables from Code Pages to DEC Multinational char set
; (DEC Supplemental Graphic). For GRight only (high bit set).
							; from Code Page 437
cp437MN db	0c7h,0fch,0e9h,0e2h, 0e4h,0e0h,0e5h,0e7h ; column 8
	db	0eah,0ebh,0e8h,0efh, 0eeh,0ech,0c4h,0c5h
	db	0c9h,0e6h,0c6h,0f4h, 0f6h,0f2h,0fbh,0f9h ; column 9
	db	0ffh,0d6h,0dch,0a2h, 0a3h,0a5h,3fh,3fh
	db	0e1h,0edh,0f3h,0fah, 0f1h,0d1h,0aah,0bah ; column 10
	db	0bfh,3fh,0ach,0bdh,  0bch,0a1h,0abh,0bbh
	db	16 dup (3fh)				 ; column 11
	db	16 dup (3fh)				 ; column 12
	db	16 dup (3fh)				 ; column 13
	db	3fh,0dfh, 4 dup (3fh),		0b5h,3fh ; column 14
	db	5 dup(3fh),		    0f8h,3fh,3fh
	db	3fh,0b1h, 4 dup (3fh),		  0h,3fh ; column 15
	db	0b0h, 4 dup (3fh),	   0b2h,0b7h,3fh
							 ; from Code Page 850
cp850MN db	0c7h,0fch,0e9h,0e2h, 0e4h,0e0h,0e5h,0e7h ; column 8
	db	0eah,0ebh,0e8h,0efh, 0eeh,0ech,0c4h,0c5h
	db	0c9h,0e6h,0c6h,0f4h, 0f6h,0f2h,0fbh,0f9h ; column 9
	db	0ffh,0d6h,0dch,0f8h, 0a3h,0d8h,58h,3fh
	db	0e1h,0edh,0f3h,0fah, 0f1h,0d1h,0aah,0bah ; column 10
	db	0bfh,0aeh,0ach,0bdh, 0bch,0a1h,0abh,0bbh
	db	5 dup (3fh),		  0c1h,0c2h,0c0h ; column 11
	db	0a9h, 4 dup (3fh),	  0a2h,0a5h,0ach
	db	6 dup (3fh),0e3h,0c3h, 7 dup (3fh),0a4h	 ; column 12
	db	0f0h,0d0h,0cah,0cbh, 0c8h,0b9h,0cdh,0ceh ; column 13
	db	0cfh, 4 dup (3fh),	   7ch,0cch,3fh
	db	0d3h,0dfh,0d4h,0d2h, 0f5h,0d5h,0b5h,0deh ; column 14
	db	0feh,0dah,0dbh,0d9h, 0fdh,0ddh,0afh,0b4h
	db	0adh,0b1h,3dh,0beh,  0b6h,0a7h,00h,22h	 ; column 15
	db	0b0h,0a8h,3fh,0b9h,  0b2h,0b3h,0b7h,20h
							 ; from Code Page 860
cp860MN db	0c7h,0fch,0e9h,0e2h, 0e3h,0e0h,0c1h,0e7h ; column 8
	db	0eah,0cah,0e8h,0cch, 0d4h,0ech,0c3h,0c2h
	db	0c9h,0c0h,0c8h,0f4h, 0f5h,0f2h,0dah,0f9h ; column 9
	db	0cch,0d5h,0dch,0a2h, 0a3h,0d9h,3fh,0d3h
	db	0e1h,0edh,0f3h,0fah, 0f1h,0d1h,0aah,0bah ; column 10
	db	0bfh,0d2h,0ach,0bdh, 0bch,0a1h,0abh,0bbh
	db	16 dup (3fh)				 ; column 11
	db	16 dup (3fh)				 ; column 12
	db	16 dup (3fh)				 ; column 13
	db	3fh,0dfh, 4 dup (3fh),		0b5h,3fh ; column 14
	db	5 dup(3fh),		    0f8h,3fh,3fh
	db	3fh,0b1h, 4 dup (3fh),		  0h,3fh ; column 15
	db	0b0h, 4 dup (3fh),	   0b2h,0b7h,3fh
							 ; from Code Page 863
cp863MN db	0c7h,0fch,0e9h,0e2h, 0e2h,0e0h,0b6h,0a2h ; column 8
	db	0eah,0ebh,0e8h,0efh, 0eeh,3dh,0c0h,0a7h
	db	0c9h,0c8h,0cah,0f4h, 0cbh,0cfh,0fbh,0fah ; column 9
	db	0a4h,0d4h,0dch,0a2h, 0a3h,0d9h,0dbh,3fh
	db	7ch,0b4h,0f3h,0fah, 0a8h,0a8h,0b3h,0afh ; column 10
	db	0ceh,3fh,0ach,0bdh,  0bch,0beh,0abh,0bbh
	db	16 dup (3fh)				 ; column 11
	db	16 dup (3fh)				 ; column 12
	db	16 dup (3fh)				 ; column 13
	db	3fh,0dfh, 4 dup (3fh),		0b5h,3fh ; column 14
	db	5 dup(3fh),		    0f8h,3fh,3fh
	db	3fh,0b1h, 4 dup (3fh),		  0h,3fh ; column 15
	db	0b0h, 4 dup (3fh),	   0b2h,0b7h,3fh
							 ; from Code Page 865
cp865MN db	0c7h,0fch,0e9h,0e2h, 0e4h,0e0h,0e5h,0e7h ; column 8
	db	0eah,0ebh,0e8h,0efh, 0eeh,0ech,0c4h,0c5h
	db	0c9h,0e6h,0c6h,0f4h, 0f6h,0f2h,0fbh,0fah ; column 9
	db	0ffh,0d6h,0dch,0f8h, 0a3h,0d8h,3fh,3fh
	db	0e2h,0edh,0f3h,0fah, 0f1h,0d1h,0aah,0bah ; column 10
	db	0bfh,3fh,0ach,0bdh,  0bch,0a1h,0abh,0a4h
	db	16 dup (3fh)				 ; column 11
	db	16 dup (3fh)				 ; column 12
	db	16 dup (3fh)				 ; column 13
	db	3fh,0dfh, 4 dup (3fh),		0b5h,3fh ; column 14
	db	5 dup(3fh),		    0f8h,3fh,3fh
	db	3fh,0b1h, 4 dup (3fh),		  0h,3fh ; column 15
	db	0b0h, 4 dup (3fh),	   0b2h,0b7h,3fh

			; Dec Technical set to CP437, CP860, CP863, CP865
			; Note: CP850 lacks the symbols so expect trash
dectech db	32 dup (0)				; columns 8 and 9
	db	0h,0fbh,0dah,0c4h, 0f4h,0f5h,0b3h,0dah	; column 10
	db	0c0h,0bfh,0d9h,28h,28h,29h,29h,0b4h
	db	0c3h,3ch,3eh,5ch,  2fh,0bfh,0d9h,03eh	; column 11
	db	0a8h,20h,20h,20h,  0f3h,3dh,0f2h,3fh
	db	1eh,0ech,0ech,0f6h,1eh,1fh,0e8h,0e2h	; column 12
	db	0f7h,0f7h,0e9h,58h,3fh,1dh,1ah,0f0h
	db	0e3h,3fh,20h,0e4h, 20h,20h,0fbh,0eah	; column 13
	db	3fh,54h,3fh,3fh,   0efh,55h,5eh,76h
	db	0aah,0e0h,0e1h,78h,0ebh,0eeh,0edh,3fh	; column 14 
	db	6eh,69h,0e9h,6bh,  3fh,20h,76h,3fh
	db	0e3h,3fh,70h,0e5h, 0e7h,0a8h,9fh,77h	; column 15
	db	45h,76h,3fh,1bh,   18h,1ah,19h,7fh
	db	94,3eh,0			; 94 byte set, letter ident
data	ends

code	segment
	assume	cs:code, ds:data, es:nothing

; Set reg BX to offset of table for Code Page to DEC Multinational Char Set
; (DEC Supplemental Graphics)
CPDECSG proc	near
	mov	bx,offset cp437MN	; assume CP437
	cmp	flags.chrset,437	; current Code Page is 437?
	je	cpdecsx			; e = yes
	mov	bx,offset cp850MN	; assume CP850
	cmp	flags.chrset,850	; current Code Page is 850?
	je	cpdecsx			; e = yes
	mov	bx,offset cp860MN	; assume CP860
	cmp	flags.chrset,860	; current Code Page is 860?
	je	cpdecsx			; e = yes
	mov	bx,offset cp863MN	; assume CP863
	cmp	flags.chrset,863	; current Code Page is 863?
	je	cpdecsx			; e = yes
	mov	bx,offset cp865MN	; assume CP865
	cmp	flags.chrset,865	; current Code Page is 865?
	je	cpdecsx			; e = yes
	mov	bx,offset cp437MN	; default to CP437
CPDECSX:ret
CPDECSG endp
; Set register SI to the offset of the NRC table appropriate to the
; currently active Code Page. Defaults to CP437 if no CP found.
NRC2CP	proc	near
	push	bx
	push	dx
	cmp	dosnum,0300h+30		; DOS version 3.30 or higher?
	jb	nrc2cp1			; b = no, no Code Pages
	mov	ax,6601h		; get global Code Page
	int	dos			; bx=active Code Page, dx=boot CP
	cmp	bx,437			; current Code Page is 437?
	je	nrc2cp1			; e = yes
	mov	si,offset NRC850	; assume CP850
	cmp	bx,850			; current Code Page is 850?
	je	nrc2cpx			; e = yes
	mov	si,offset NRC860	; assume CP860
	cmp	bx,860			; current Code Page is 860?
	je	nrc2cpx			; e = yes
	mov	si,offset NRC863	; assume CP863
	cmp	bx,863			; current Code Page is 863?
	je	nrc2cpx			; e = yes
	mov	si,offset NRC865	; assume CP865
	cmp	bx,865			; current Code Page is 865?
	je	nrc2cpx			; e = yes
nrc2cp1:mov	si,offset NRC437	; default to CP437
nrc2cpx:pop	dx
	pop	bx
	ret
NRC2CP	endp


code	ends
	end
