;+ This is MSZP98.ASM
;
;  Utility and SetUp Package for NEC PC-9801
;  Author: Hirofumi Fujii (KEK On-line group)
;  Last Edited: 17-Apr-1990
;  17-Apr-1991  deleted prn_out
;  05-Apr-1991  added pcwtst
;  30-Sep-1990	added text_scrn
;  27-Sep-1990	VTS comes here !
;  13-Aug-1990	added sense_sftkey
;  24-Jul-1990	for MS-Kermit v3.02
 
	include	mssdef.h
	include	msxp98.h
 
	public	vts
	public	s2jis, jis2s, is_kanji1
	public	set_keydef, reset_keydef
	public	set_cursor
	public	sense_sftkey
	public	text_scrn
	public	pc98_bell
	public	pcwait, pcwtst
 
data 	segment	public 'data'
 
;-------------------------------------------------------------------
; Data for set-up routine
;-------------------------------------------------------------------
	extrn	flags:byte
	extrn	comand:byte		; in MSSCMD.ASM
	extrn	denyflg:word
	extrn	cpu_clock:byte, vtgrph_flg:byte, vttest_flg:byte
	extrn	curkey_mode:byte, keypad_mode:byte
	extrn	display_mode:byte
	extrn	keyin_dos:byte
	extrn	kanji_rcode:byte, kanji_scode:byte
	extrn	vt100_cursr:byte
	extrn	vt100_flags:byte, vt100_pflag:byte
	extrn	vt100_lflag:byte, vt100_gflag:byte
	extrn	def_color:byte, scn_color:byte

pcwcnt		dw	480		; wait count
pcwtst_vect	dw	0, 0, 0, 0
pcwtst_done	dw	0

param_dst	dw	?
temp		dw	?
 
vthlp	db	' one of the following:',cr,lf
	db	'  Terminal types of: None, VT102, or '
	db	'Tek4014',cr,lf
	db	'  Clock (5MHz,8MHz,10MHz)            ',cr,lf
	db	'  Keyclick (on/off)                  '
	db	'  Keyinput (BIOS/CON/DOS)            ',cr,lf
	db	'  Keypad-mode (application/normal)   '
	db	'  Cursorkey-mode (application/normal)',cr,lf
	db	'  Foreground (white,yellow...)       '
	db	'  Background (black,blue...)         ',cr,lf
	db	'  Highlight (yellow,magenta...)      '
	db	'  Modeline-color (white,green...)    ',cr,lf
	db	'  Kanji-code (DEC-code,Shift-JIS,JIS-'
	db	'7, or none)',cr,lf
	db	'  Insert-mode (on/off)               '
	db	'  Origin-mode (on/off)               ',cr,lf
	db	'  Newline-mode (on/off)              '
	db	'  Wrap (on/off)                      ',cr,lf
	db	'  Cooked-log (on/off)                ',cr
	db	'$'
 
; VT setup command table
; The higher byte indicates the group of the command.
;   100H   -- terminal type
;   300H   -- color group
;   400H   -- Kanji group
;   500H   -- Keymode application/normal
;   600H   -- Playback file
;   700H   -- clear
;  2000H   -- vt100_flags on/off
;  2100H   -- vt100_pflag on/off
;  2200H   -- vtgrph_flg on/off
;  2300H   -- vt100_lflag on/off
;  2400H   -- vttest_flg on/off
;
; <<< DO NOT forget to update the number of items at 'vttbl' when you add
;     new item to the following list >>>
vttbl	db	36
	mkeyw	'Background',301H
	mkeyw	'Clear-screen',700H
	mkeyw	'Clock',503H
	mkeyw	'Color',300H
	mkeyw	'Cooked-log',LOGCOOK_BIT+2300H
	mkeyw	'Cursorkey-mode',502H
	mkeyw	'Display-mode',504H
	mkeyw	'Exit-graphic',EXITG_BIT+2200H
	mkeyw	'Foreground',300H
	mkeyw	'GWait',GCLRWAIT_BIT+2200H
	mkeyw	'Highlight',302H
	mkeyw	'Insert-mode',INSERT_BIT+2000H
	mkeyw	'Kanji-Code',400H
	mkeyw	'Keyclick',KEYCLICK_BIT+2000H
	mkeyw	'Keyinput',500H
	mkeyw	'Keypad-mode',501H
	mkeyw	'Modeline-color',303H
	mkeyw	'Mouse',MOUSE_BIT+2200H
	mkeyw	'Newline-mode',NEWLINE_BIT+2000H
	mkeyw	'None',ttgenrc+100H	; note 100H flag for decoding here
	mkeyw	'Origin-mode',ORIGIN_BIT+2000H
	mkeyw	'Playback',600H
	mkeyw	'PrintEXT',PRINTEXT_BIT+2100H
	mkeyw	'PrintFF',PRINTFF_BIT+2100H
	mkeyw	'Tek4014',tttek+100H
	mkeyw	'test1',2401H
	mkeyw	'test2',2402H
	mkeyw	'test3',2404H
	mkeyw	'test4',2408H
	mkeyw	'test5',2410H
	mkeyw	'test6',2420H
	mkeyw	'test7',2440H
	mkeyw	'test8',2480H
	mkeyw	'VT102',ttvt100+100H
	mkeyw	'VT52',ttvt52+100H
	mkeyw	'Wrap',AUTOWRAP_BIT+2000H
; <<< DO NOT forget to update the number of items at 'vttbl' when you add
;     new item to the above list >>>
 
ontab	db	2
	mkeyw	'off',0
	mkeyw	'on',1
 
colortab	db	8
	mkeyw	'black',0
	mkeyw	'blue',1
	mkeyw	'cyan',5
	mkeyw	'green',4
	mkeyw	'magenta',3
	mkeyw	'red',2
	mkeyw	'white',7
	mkeyw	'yellow',6
 
disatab		db	2		; Tek disable/enable table
        mkeyw   'disable',1
        mkeyw   'enable',0
 
kanjitab	db	4
	mkeyw	'DEC-code',KNJCODE_DEC
	mkeyw	'JIS-7',KNJCODE_JIS7
	mkeyw	'None',KNJCODE_NONE
	mkeyw	'Shift-JIS',KNJCODE_SJIS
 
keyintab	db	4
	mkeyw	'BIOS',0
	mkeyw	'CON',1
	mkeyw	'direct',0
	mkeyw	'DOS',2
 
keypadtab	db	2
	mkeyw	'Application',1
	mkeyw	'normal',0
 
clocktab	db	3
	mkeyw	'10MHz',CPU_5M_CLOCK
	mkeyw	'5MHz',CPU_5M_CLOCK
	mkeyw	'8MHz',CPU_8M_CLOCK
 
displaytab	db	2
	mkeyw	'Analogue',1
	mkeyw	'Digital',0
;
;---------------------------------------------------------------------------
; Function key definition tables
 
ker_keydef	db	0FEh,'f 01 ',0FFh,062h, 8 dup (0)	; f 1
		db	0FEh,'f 02 ',0FFh,063h, 8 dup (0)	; f 2
		db	0FEh,'f 03 ',0FFh,064h, 8 dup (0)	; f 3
		db	0FEh,'f 04 ',0FFh,065h, 8 dup (0)	; f 4
		db	0FEh,'f 05 ',0FFh,066h, 8 dup (0)	; f 5
		db	0FEh,'f 06 ',0FFh,067h, 8 dup (0)	; f 6
		db	0FEh,'f 07 ',0FFh,068h, 8 dup (0)	; f 7
		db	0FEh,'f 08 ',0FFh,069h, 8 dup (0)	; f 8
		db	0FEh,'f 09 ',0FFh,06Ah, 8 dup (0)	; f 9
		db	0FEh,'f 10 ',0FFh,06Bh, 8 dup (0)	; f10
		db	0FEh,'F 01 ',0FFh,082h, 8 dup (0)	; shift f 1
		db	0FEh,'F 02 ',0FFh,083h, 8 dup (0)	; shift f 2
		db	0FEh,'F 03 ',0FFh,084h, 8 dup (0)	; shift f 3
		db	0FEh,'F 04 ',0FFh,085h, 8 dup (0)	; shift f 4
		db	0FEh,'F 05 ',0FFh,086h, 8 dup (0)	; shift f 5
		db	0FEh,'F 06 ',0FFh,087h, 8 dup (0)	; shift f 6
		db	0FEh,'F 07 ',0FFh,088h, 8 dup (0)	; shift f 7
		db	0FEh,'F 08 ',0FFh,089h, 8 dup (0)	; shift f 8
		db	0FEh,'F 09 ',0FFh,08Ah, 8 dup (0)	; shift f 9
		db	0FEh,'F 10 ',0FFh,08Bh, 8 dup (0)	; shift f10
		db	0FFh,036h, 4 dup (0)	; ROLL UP
		db	0FFh,037h, 4 dup (0)	; ROLL DOWN
		db	0FFh,038h, 4 dup (0)	; INS
		db	0FFh,039h, 4 dup (0)	; DEL
		db	0FFh,03Ah, 4 dup (0)	; up arrow
		db	0FFh,03Bh, 4 dup (0)	; left arrow
		db	0FFh,03Ch, 4 dup (0)	; right arrow
		db	0FFh,03Dh, 4 dup (0)	; down arrow
		db	0FFh,03Eh, 4 dup (0)	; HOME CLR
		db	0FFh,03Fh, 4 dup (0)	; HELP
		db	0FFh,0AEh, 4 dup (0)	; shift HOME CLR
KEYDEF_SIZE = $ - ker_keydef + 2
 
DOS_keydef	db	KEYDEF_SIZE dup (?)
 
;
data	ends
 
code	segment	public 'code'
	assume	cs:code,ds:data,es:nothing
 
	extrn	comnd:near		; in MSSCMD
	extrn	set_cur_color:near	; in MSXP98
	extrn	vt100_color:near	; in MSYP98
	extrn	tek4014_color:near	; in MSGP98
 
;-------------------
is_kanji1	proc	near
;
; Check if al is Kanji 1st byte (stc) or not (clc)
;
	cmp	al,81h
	jb	is_kanji1_no
	cmp	al,0FCh
	ja	is_kanji1_no
	cmp	al,9fh
	jbe	is_kanji1_yes
	cmp	al,0E0h
	jae	is_kanji1_yes
is_kanji1_no:
	clc
	ret
is_kanji1_yes:
	stc
	ret
is_kanji1	endp
 
;-------------------
jis2s	proc	near
;
; Convert JIS Kanji code in AX to shift-JIS Kanji code
;	ah	2nd byte
;	al	1st byte
;
	test	al,1
	jz	jis2s1
	add	ah,1Fh
	jmp	jis2s2
jis2s1:
	add	ah,7Dh
jis2s2:
	cmp	ah,7Fh
	jb	jis2s3
	add	ah,1
jis2s3:
	sub	al,21h
	shr	al,1
	add	al,81h
	cmp	al,9Fh
	jbe	jis2s4
	add	al,40h
jis2s4:
	ret
jis2s	endp
 
;-------------------
s2jis	proc	near
;
; Convert Shift JIS Kanji code in AX to JIS Kanji code
;	ah	2nd byte
;	al	1st byte
;
	cmp	al,9Fh
	ja	s2jis1
	sub	al,71h
	jmp	s2jis2
s2jis1:
	sub	al,0B1h
s2jis2:
	shl	al,1
	inc	al
	cmp	ah,7Fh
	jbe	s2jis3
	dec	ah
s2jis3:
	cmp	ah,9Eh
	jb	s2jis4
	sub	ah,7Dh
	inc	al
	jmp	s2jis5
s2jis4:
	sub	ah,1Fh
s2jis5:
	ret
s2jis	endp
 
set_keydef	proc	near
; Save MS-DOS key definition table and set new key definition table.
; This is done by calling NEC-PC98 extended bios.
 
	push	ax
	push	cx
	push	dx
 
	mov	dx,offset DOS_keydef
	mov	ax,0
	mov	cl,0Ch
	int	0DCh
	mov	dx,offset ker_keydef
	mov	ax,0
	mov	cl,0Dh
	int	0DCh
 
	pop	dx
	pop	cx
	pop	ax
	ret
set_keydef	endp
 
reset_keydef	proc	near
; Restore MS-DOS key definition table
 
	push	ax
	push	cx
	push	dx
 
	mov	dx,offset DOS_keydef
	mov	ax,0
	mov	cl,0Dh
	int	0DCh
 
	pop	dx
	pop	cx
	pop	ax
	ret
reset_keydef	endp
 
;---------------------------
text_scrn	proc	near
;
; Text screen on/off control
;
; Input		AL: 0      off
;                   others on
;
	push	ax
	push	bx
	mov	bl,0Ch		; assume off
	cmp	al,0		; want off ?
	je	text_scrn_1	; e=yes
	mov	bl,0Dh		; on
text_scrn_1:
	in	al,60h		; Read Text GDC status
	test	al,04h		; GDC buffer empty ?
	jz	text_scrn_1	; z=no
	mov	al,bl
	out	62h,al		; send command
	pop	bx
	pop	ax
	ret
text_scrn	endp
;
;---------------------------
set_cursor	proc	near
;
; set cursor
; Input		AX: cursor attributes
;		    bit0    0:visible,   1:invisible
;                   bit1    0:blink,     1:noblink
;                   bit2    0:block,     1:underline
;
	push	ax
	push	bx
	mov	bx,ax
	cli
set_cursor1:
	in	al,60h		; Read Text GDS status
	test	al,04h		; GDC buffer empty ?
	jz	set_cursor1	; z = no
	mov	al,4Bh		; CSFORM command
	out	62h,al		; send command
	mov	al,8Fh		; CS=1, L/R=15
	test	bx,1		; cursor off ?
	jz	set_cursor2	; z = no
	mov	al,0Fh		; CS=0, L/R=15
set_cursor2:
	out	60h,al		; send P1 parameter
	mov	al,00h		; BD=0, CST=0
	test	bx,2		; blink ?
	jz	set_cursor3	; z = yes. blink cursor
	mov	al,20h		; BD=1, CST=0
set_cursor3:
	test	bx,4		; underline ?
	jz	set_cursor4	; z = no.
	add	al,0Eh		; CST=14
set_cursor4:
	out	60h,al		; send P2 parameter
	mov	al,07Bh		; CFI=15, BL=12
	out	60h,al		; send P3 parameter
	sti
	pop	bx
	pop	ax
	ret
set_cursor	endp
 
;-----------------------------------------------------------------------
; Bell routine
;
pc98_bell	proc	near
	push	ax
	push	cx
;
	mov	al,06h		; bell on
	out	37h,al
	mov	cx,0D000h	; counter
pc98_bell_loop:
	loop	pc98_bell_loop
	mov	al,07h		; bell off
	out	37h,al
;
	pop	cx
	pop	ax
	ret
pc98_bell	endp
;-----------------------------------------------------------------------
; set the pcwcnt used in pcwait.
;
pcwtst_int	proc	near
	mov	pcwtst_done,1
	iret
pcwtst_int	endp

pcwtst	proc	near
	push	ax
	push	bx
	push	cx
	push	si
	push	di
	push	es
;
	xor	ax,ax
	mov	es,ax		; ES = 0
	cli			; disable interrupt
	mov	si,28		; save vector number 7 & 8
	mov	di,offset pcwtst_vect
	mov	ax,es:[si]
	mov	[di],ax
	mov	ax,es:[si+2]
	mov	[di+2],ax
	mov	ax,es:[si+4]
	mov	[di+4],ax
	mov	ax,es:[si+6]
	mov	[di+6],ax
;
	mov	pcwcnt,0
	mov	pcwtst_done,0
	sti			; enable interrupt
	mov	cx,10		; 100msec mesurements
	mov	ax,cs
	mov	es,ax
	mov	bx,offset pcwtst_int
	mov	ah,02h		; interval timer function number
	int	1Ch		; BIOS call
;
pcwtst0:
	cmp	pcwtst_done,0
	jne	pcwtst2
	mov	cx,100
pcwtst1:
	sub	cx,1
	jnz	pcwtst1
	inc	pcwcnt
	jmp	pcwtst0
;
pcwtst2:
	inc	pcwcnt		; add 1
	cli
	xor	ax,ax
	mov	es,ax		; ES = 0
	mov	si,28		; restore vector 7 & 8
	mov	di,offset pcwtst_vect
	mov	ax,[di]
	mov	es:[si],ax
	mov	ax,[di+2]
	mov	es:[si+2],ax
	mov	ax,[di+4]
	mov	es:[si+4],ax
	mov	ax,[di+6]
	mov	es:[si+6],ax
	sti
	pop	es
	pop	di
	pop	si
	pop	cx
	pop	bx
	pop	ax
	ret
pcwtst	endp
;-----------------------------------------------------------------------
;; Wait for the # of milliseconds in ax, for non-IBM compatibles.
; inner loop counter (pcwcnt, adjusted by proc pcwtst).
pcwait  proc    near
        push    cx
pcwai0: mov     cx,pcwcnt       ; inner loop counter for 1 ms
pcwai1: sub     cx,1            ; inner loop takes 20 clock cycles
        jnz     pcwai1
        dec     ax              ; outer loop counter
        jnz     pcwai0          ; wait another millisecond
        pop     cx
        ret
pcwait  endp

;-----------------------------------------------------------------------
; Sense shfit-key status
;
; output
;             +----+----+----+----+----+----+----+----+
;   AL        | -- | -- | -- |CTRL|GRPH|KANA|CAPS|SHFT|
;             +----+----+----+----+----+----+----+----+
sense_sftkey	proc	near
	mov	ah,02h
	int	18h
	ret
sense_sftkey	endp
 
;----------------------------------
; VT Setup routine (global routine)
;----------------------------------
VTS     PROC    NEAR
	mov	ah,cmkey		; Parse another keyword.
	mov	bx,offset vthlp		; Use this help
	mov	dx,offset vttbl		; Use this table
	call	comnd
	jnc	vsetup_n0
	ret
vsetup_n0:
	cmp	bh,1h			; marker for terminal type?
	jne	vsetup_n1		; ne = no
	jmp	vsetup_1
vsetup_n1:
	cmp	bh,20h			; set term vt100_flags on/off?
	jne	vsetup_n20		; ne = no
	jmp	vsetup_20
vsetup_n20:
	cmp	bh,21h			; set term vt100_pflag on/off?
	jne	vsetup_n21		; ne = no
	jmp	vsetup_20
vsetup_n21:
	cmp	bh,22h			; set term vtgrph_flg on/off
	jne	vsetup_n22
	jmp	vsetup_20
vsetup_n22:
	cmp	bh,23h			; set term vt100_lflag on/off
	jne	vsetup_n23
	jmp	vsetup_20
vsetup_n23:
	cmp	bh,24h			; set term vttest_flg on/off
	jne	vsetup_n24
	jmp	vsetup_20
vsetup_n24:
vsetup_n2:
	cmp	bh,3h			; marker for color
	jne	vsetup_n3		; ne = no
	jmp	vsetup_3
vsetup_n3:
	cmp	bh,4h			; marker for kanji
	jne	vsetup_n4		; ne = no
	jmp	vsetup_4
vsetup_n4:
	cmp	bh,5			; marker for keyboard
	jne	vsetup_n5
	jmp	vsetup_5
vsetup_n5:
	cmp	bh,6			; marker for playback file
	jne	vsetup_n6
	jmp	vsetup_6
vsetup_n6:
	cmp	bh,7
	jne	vsetup_n7
	jmp	vsetup_7
vsetup_n7:
	jmp	vsetup_ex
;
vsetup_1:
;
; The followings are copied from MSYIBM.ASM
;
vsetu0: mov     byte ptr temp,bl        ; set terminal type
        mov     byte ptr temp+1,-1      ; assume no enable/disable Tek
        cmp     bl,tttek                ; set term tek?
        jne     vsetu0a                 ; ne = no
        mov     dx,offset disatab       ; disable/enable keyword table
        xor     bx,bx                   ; help is the table
        mov     comand.cmcr,1           ; allow bare CR's
        mov     ah,cmkey                ; get enable/disable keyword
        call    comnd
        mov     comand.cmcr,0           ; no more bare CR's
        jc      vsetu0e                 ; c = no such keyword
        mov     byte ptr temp+1,bl      ; save enable/disable keyword value
        mov     bl,flags.vtflg          ; get current terminal type
        mov     byte ptr temp,bl        ; and force it here

vsetu0a:mov     ah,cmeol
        call    comnd                   ; get a confirm
        jc      vsetu0d                 ; c = failure
vsetu0e:mov     bx,temp
        mov     flags.vtflg,bl          ; Set the terminal emulation type
;@@	mov     tekflg,0                ; clear Tek sub mode
        cmp     bl,tttek                ; adjusting Tek?
        je      vsetu0b                 ; e = yes
        cmp     bh,-1                   ; just enable/disable tek?
        je      vsetu0c                 ; e = no
vsetu0b:and     denyflg,not tekxflg     ; enable Tek
        cmp     bh,1                    ; ought we disable?
        jne     vsetu0c                 ; ne = no
        or      denyflg,tekxflg         ; disable Tek
vsetu0c:clc                             ; success
vsetu0d:ret
 
vsetup_20:
	and	bh,1Fh
	mov	param_dst,bx
	mov	ah,cmkey
	mov	bx,0
	mov	dx,offset ontab
	call	comnd
	jnc	vsetup_2_0_1
	ret				; bad keyword
vsetup_2_0_1:
	push	bx
	mov	ah,cmeol		; get a confirm
	call	comnd
	jnc	vsetup_2_0_2
	jmp	vsetup_ex2		; did not get a confirm
vsetup_2_0_2:
	mov	ax,param_dst
	pop	bx
	cmp	bl,0
	jne	vsetup_2_on
	not	al
;
;   OFF mode
;
	cmp	ah,0
	jne	vsetup_2_off1
	and	vt100_flags,al
	jmp	vsetup_2_2
vsetup_2_off1:
	cmp	ah,1
	jne	vsetup_2_off2
	and	vt100_pflag,al
	jmp	vsetup_2_2
vsetup_2_off2:
	cmp	ah,2
	jne	vsetup_2_off3
	and	vtgrph_flg,al
	jmp	vsetup_2_2
vsetup_2_off3:
	cmp	ah,3
	jne	vsetup_2_off4
	and	vt100_lflag,al
	jmp	vsetup_2_2
vsetup_2_off4:
	cmp	ah,4
	jne	vsetup_2_off5
	and	vttest_flg,al
vsetup_2_off5:
	jmp	vsetup_2_2
;
;  ON mode
;
vsetup_2_on:
	cmp	ah,0
	jne	vsetup_2_on1
	or	vt100_flags,al
	jmp	vsetup_2_2
vsetup_2_on1:
	cmp	ah,1
	jne	vsetup_2_on2
	or	vt100_pflag,al
	jmp	vsetup_2_2
vsetup_2_on2:
	cmp	ah,2
	jne	vsetup_2_on3
	or	vtgrph_flg,al
	jmp	vsetup_2_2
vsetup_2_on3:
	cmp	ah,3
	jne	vsetup_2_on4
	or	vt100_lflag,al
	jmp	vsetup_2_2
vsetup_2_on4:
	cmp	ah,4
	jne	vsetup_2_on5
	or	vttest_flg,al
	jmp	vsetup_2_2
vsetup_2_on5:
vsetup_2_2:
;;	jmp	rskp
	clc
	ret
 
vsetup_3:
	mov	dx,offset def_color
	xor	bh,bh
	add	dx,bx
	mov	param_dst,dx
 
	mov	ah,cmkey
	mov	bx,0
	mov	dx,offset colortab
	call	comnd
	jnc	vsetup_3_1
	ret				; bad keyword
vsetup_3_1:
	push	bx
	mov	ah,cmeol		; get a confirm
	call	comnd
	jnc	vsetup_3_2
	jmp	vsetup_ex2		; did not get a confirm
vsetup_3_2:
	pop	dx			; get old bx value to dx
	mov	bx,param_dst
	mov	byte ptr [bx],dl
	push	si
	mov	si,offset def_color
	cmp	bx,si			; if foreground color, set modecol also
	jne	vsetup_3_7
	mov	byte ptr [bx+3],dl
vsetup_3_7:
	call	set_cur_color
	call	vt100_color
	call	tek4014_color
	pop	si
;;	jmp	rskp
	ret
 
vsetup_4:
	mov	ah,cmkey
	mov	bx,0
	mov	dx,offset kanjitab
	call	comnd
	jnc	vsetup_4_1
	ret				; bad keyword
vsetup_4_1:
	push	bx
	mov	ah,cmeol		; get a confirm
	call	comnd
	jnc	vsetup_4_2
	jmp	vsetup_ex2		; did not get a confirm
vsetup_4_2:
	pop	bx			; get old bx value to dx
	mov	kanji_scode,bl
	mov	kanji_rcode,bl
;;	jmp	rskp
	ret
 
vsetup_5:
	xor	bh,bh
	cmp	bx,0
	jne	vsetup_5n0
	mov	dx,offset keyin_dos
	mov	param_dst,dx
	mov	dx,offset keyintab
	jmp	vsetup_5do
vsetup_5n0:
	cmp	bx,1
	jne	vsetup_5n1
	mov	dx,offset keypad_mode
	mov	param_dst,dx
	mov	dx,offset keypadtab
	jmp	vsetup_5do
vsetup_5n1:
	cmp	bx,2
	jne	vsetup_5n2
	mov	dx,offset curkey_mode
	mov	param_dst,dx
	mov	dx,offset keypadtab
	jmp	vsetup_5do
vsetup_5n2:
	cmp	bx,3
	jne	vsetup_5n3
	mov	dx,offset cpu_clock
	mov	param_dst,dx
	mov	dx,offset clocktab
	jmp	vsetup_5do
vsetup_5n3:
	cmp	bx,4
	jne	vsetup_5n4
	mov	dx,offset display_mode
	mov	param_dst,dx
	mov	dx,offset displaytab
	jmp	vsetup_5do
vsetup_5n4:
;;	jmp	rskp
	ret
vsetup_5do:
	mov	ah,cmkey
	mov	bx,0
	call	comnd
	jnc	vsetup_5do_1
	ret
vsetup_5do_1:
	push	bx
	mov	ah,cmeol
	call	comnd
	jnc	vsetup_5do_2
	jmp	vsetup_ex2
vsetup_5do_2:
	pop	dx
	mov	bx,param_dst
	mov	byte ptr [bx],dl
;;	jmp	rskp
	ret
 
vsetup_6:
 
; Set playback filename. Taken from 'setdmp' in MSSSET.ASM
; Puts filename in global string playback_fnam.
; Discared due to device independent module has playback command now.
;        mov     dx,offset rdbuf         ; work area
;        mov     rdbuf,0                 ; clear it
;        mov     bx,offset playback_hlp  ; help message
;        mov     ah,cmword               ; allow paths
;        call    comnd
;        jnc	vsetup_6_1
;        ret
;vsetup_6_1:
;        mov     ah,cmeol
;        call    comnd
;        jnc	vsetup_6_2
;        ret
;vsetup_6_2:
;        mov     dx,offset rdbuf         ; assume we will use this text
;        call    strlen                  ; filename given?
;        mov     si,dx                   ; for strcpy
;        cmp     cx,0                    ; length of user's filename
;        jg      vsetup_6_3              ; g = filename is given
;        mov     si,offset playback_defnam     ; no name, use default instead
;vsetup_6_3:
;        mov     di,offset playback_fnam       ; copy to globally available loc
;        call    strcpy
;        or	vt100_flags,LOOPTEST_BIT
;;        jmp     rskp
	ret
 
vsetup_7:
;	push	bx
;	mov	ah,cmeol
;	call	comnd
;	jnc	vsetup_7_1
;	jmp	vsetup_ex2
vsetup_7_1:
;	call	vtreset
	ret

vsetup_ex:
;;	jmp	rskp
	ret
vsetup_ex2:
	pop	bx
	ret
 
VTS     ENDP
 

code	ends
	end
