# File MSVWNG.MAK.
#
# Makefile for MS-DOS Kermit on WANG (Advanced) Professtional Computer family.
# For use Microsoft's Make version 4.00.
# Usage: "make msvwng.mak" with all source files in current directory.
#
# Original MSVIBM.MAK written by Joe R. Doupnik,
# adapted to MSVWNG.MAK by V. Edelhoff
# Blank lines are mandatory.

# The inference macro below calls MASM to create .obj modules.
.asm.obj:
        MASM $*.asm;

# These are the dependency relations (.obj depends on .asm and .h):
# First, the system independent files for Kermit-MS.

# Make this     using MASM on these two files if either has changed

msscmd.obj:     msscmd.asm mssdef.h

msscom.obj:     msscom.asm mssdef.h

mssfil.obj:     mssfil.asm mssdef.h

mssker.obj:     mssker.asm mssdef.h

mssrcv.obj:     mssrcv.asm mssdef.h

mssscp.obj:     mssscp.asm mssdef.h

msssen.obj:     msssen.asm mssdef.h

mssser.obj:     mssser.asm mssdef.h

mssset.obj:     mssset.asm mssdef.h

msster.obj:     msster.asm mssdef.h

mssfin.obj:     mssfin.asm mssdef.h

# These are the system dependent modules for the WANG PC/APC. Use with the
# appropriate Link command file msvwng.lnk.

msxwng.obj:	msxwng.asm mssdef.h

msvwng.exe:	msscmd.obj msscom.obj mssfil.obj mssker.obj mssrcv.obj\
                mssscp.obj msssen.obj mssser.obj mssset.obj msster.obj\
		msxwng.obj \
                mssfin.obj
	LINK @msvwng.lnk




msvwng.boo:	msvwng.exe
	msbmkb msvwng.exe msvwng.boo

# Do the items above when Kermit is rebuilt.  Notice the use of a command
# file for Link because the list of object files is too long for one line.
# A sample command file MSVWNG.LNK is (MSSFIN must be LAST):
#
# msscmd+msscom+mssfil+mssker+mssrcv+msssen+mssser+
# mssset+msster+msxwng+mssfin
# msvwng;

# End of Kermit Make file for the WANG (Advanced) Professional Computer family.

