C     This Fortran program should be run on the mainframe in conjunction
C     with a Basic program (MSPCBOOT.BAS) on the PC to transfer
C     MSKERMIT.BOO to the PC and translate it into KERMIT.EXE.  This
C     program uses a very rudimentary technique to try to insure that
C     the characters it sends arrive correctly.  It just sends a count
C     of the number of characters sent after each line.  In this way any
C     errors of character loss or insertion will be caught.  If a
C     character is just corrupted it will not be caught.  Hopefully if
C     this happens it will be in a non-critical part of the KERMIT.EXE
C     file.  The reason a simple checksum was not used was so that this
C     program could run on machines using either EBCDIC or ASCII
C     characters.  This program should take about thirty minutes to run.
C
C     This program assumes that the standard input and standard output units
C     are directed to the terminal.  The program prompts for the name of a
C     file to transfer (e.g. MSKERMIT.BOO) and opens unit 7 with than name.
C
C     Modified by:
C     Tom Putnam, Purdue University Computing Center, Dec. 1985.
C     (changed to FORTRAN 77, prompt for file name, cleanup)
C
C     Original by:
C     Bill Catchings, Columbia University Center for Computing Activities
C     June 1984 (Revised September 1984)
C
      CHARACTER*1 LINE(77), ACK, OK, SPACE, COMMA
      CHARACTER*30 FNAME

      PRINT *, 'Enter the full name of the .BOO file to transfer'
      READ (*,5) FNAME
5     FORMAT(A30)
      OPEN(UNIT=7,FILE=FNAME,STATUS='OLD',ERR=99)

      PRINT *,'Ready to transfer data, now run MSPCBOOT.BAS on the PC.'

C     Get characters for constants (character constants are rough in
C     some FORTRANs).
      READ (*,10) OK, SPACE, COMMA, ACK
10    FORMAT(4A1)

C     Get new line from file.
20    READ (7,30,END=80)LINE
30    FORMAT(77A1)

C     Count the characters as some rudimentary check for noise.
      I = 1
40    IF (LINE(I) .EQ. SPACE) GO TO 50
      I = I + 1
      GO TO 40

C     Put in a comma followed by the count.
50    LINE(I) = COMMA

C     Write to TTY.
60    WRITE (*,70)LINE,I-1
70    FORMAT(77A1,I2)

C     Get terminal handshake.
      READ (*,10)ACK

C     Did the other side like it?  (Did they send OK?)
      IF (ACK .NE. OK) GO TO 60
      GOTO 20

C     Send good-bye message.
80    WRITE (*,90)
90    FORMAT(10('&'),',10')
      STOP

C     Here if error opening file
99    PRINT *,'Error - cannot open file = ',FNAME
      STOP
      END
